#include "F_externe_nD.h"
using namespace std;  //introduces namespace std

// --- fichier pour le tube ------
#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <fcntl.h> /* Pour O_WRONLY, etc */

#include <unistd.h>    // pour les ordres read write close

#include <math.h>



int stat(const char *path, struct stat *buf);



    // CONSTRUCTEURS :
F_externe_nD::F_externe_nD() :
 reception("cont_precision_envoi_Hz.FIFO"),envoi("cont_precision_reception_Hz.FIFO")  // a modifier en fonction du nom donné par Herezh
 // il suffit de lancer Herezh avec un niveau d'affichage pour la fonction externe > 0
 // Herezh écrit alors sur cout le nom des pipes nommés
 ,nom("cont_precision")
 ,permet_affichage(1)
 ,nb_variable(0),nb_retour(0)
  {};
    

    // DESTRUCTEUR :
F_externe_nD::~F_externe_nD()
  {};
    
// METHODES PUBLIQUES :
    
// exécution de la Fonction
void F_externe_nD::Execution()
  {
    // lecture des données sur le pipe
    LecturePipe();
    
    // exemple de fonction: ici on calcul le sinus de la première variable
//    t_car_x_n.x[1] = sin(t_car_x_n.x[1]);
    
    t_car_x_n.x[1] = 6. * t_car_x_n.x[1];
    // on ramène une seule valeur
    t_car_x_n.n[1] = nb_retour = 1;
    
    // écriture des résultats sur le pipe
    EcriturePipe();

  };

// initialisation des pipes
void F_externe_nD::InitialisationPipesNommes()
 { try
    { // pipe de sortie
      // on test l'existence du pipe
      struct stat buf;
      int tub=0; // init
      int etat = stat(envoi.c_str(), &buf);
      
      int tube_a_cree = 0;
      if (etat == -1) // cela veut dire que la fonction stat n'a pas fonctionné
        // on part sur le principe que les tubes n'existent pas
        {tube_a_cree=1;}
      else if (!S_ISFIFO(buf.st_mode))
        {tube_a_cree=1;};
      if (tube_a_cree ) // cas où le tube n'existe pas
       {tub = mkfifo (envoi.c_str(), S_IRWXU);
        if (tub == -1 ) // gestion d'erreur éventuelle
         {std::cout << "\n *** erreur en creation du tube nomme: " << envoi << ", de sortie  pour la "
               << " fonction externe "<< nom
               << "\n F_externe_nD::InitialisationPipesNommes() "<<flush;
         }
        else
         { cout << "\n creation du pipe nomme: "<< envoi << " pour la "
                << " fonction externe "<< nom << flush;
         } ;
        close (tub); // fermeture du tampon
       }
     else
       { cout << "\n utilisation du pipe nomme: "<< reception << " pour la "
              << " fonction externe "<< nom << flush;
       } ;
     tub = 0;         // réinit
     tube_a_cree = 0; // réinit
    
     // ouverture du tube nommé en lecture
     etat = stat(reception.c_str(), &buf);
     if (etat == -1) // cela veut dire que la fonction stat n'a pas fonctionné
       // on part sur le principe que les tubes n'existent pas
       {tube_a_cree=1;}
     else if (!S_ISFIFO(buf.st_mode))
       {tube_a_cree=1;};
     if (tube_a_cree ) // cas où le tube n'existe pas
      {tub = mkfifo (reception.c_str(), S_IRWXU);
       if (tub == -1 ) // gestion d'erreur éventuelle
        {cout << "\n *** erreur en creation du tobe nomme: " << reception << ", de lecture d'herezh pour la "
              << " fonction externe "<< nom
              << "\n F_externe_nD::InitialisationPipesNommes() "<<flush;
         exit(1);
        }
       else
        { cout << "\n creation du pipe nomme: "<< reception << " pour la "
              << " fonction externe "<< nom << flush;
        } ;
       close (tub); // fermeture du tampon
      }
     else
      { cout << "\n utilisation du pipe nomme: "<< reception << " pour la "
             << " fonction externe "<< nom << flush;
      } ;

    
    }
   catch(...)
    {cout << "\n *** erreur inconnue lors de l'initialisation des pipes I/O pour la "
          << " fonction externe "<< nom
          << "\n F_externe_nD::InitialisationPipesNommes() "<<flush;
     exit(1);
    };
 
 };


// lecture des données
void F_externe_nD::LecturePipe()
{
 try
  {//  Creation d'un processus de reception des données
   // en fait l'objectif est de réceptionner que les variables d'entrées ou
   // d'entrée sortie
   if (permet_affichage )
     cout << "\n :  ouverture du tube en lecture, lecture sur le tube"
          << reception << endl;


  //      union Tab_car_double_int_1
  //      {  char    tampon[928];
  //         double  x[116];
  //         int     n[232];
  //      } ;

    // le premier élément est le nombre de grandeurs  à lire
    // le second élément est le nombre de grandeurs que l'on attend en retour
    int nb_carac_a_lire = 2*4 ;
    int tub = open(reception.c_str(),O_RDONLY);
    char* tampon_reception =  &(t_car_x_n.tampon[0]);
    read (tub,tampon_reception,nb_carac_a_lire);
    if (permet_affichage )
        {cout << "\n lecture de " << t_car_x_n.n[0] << " reels ";};
    // puis lecture des variables de passage
    nb_variable=t_car_x_n.n[0];
    nb_carac_a_lire = t_car_x_n.n[0] * 8;
    tampon_reception =  &(t_car_x_n.tampon[8]);
    read (tub,tampon_reception,nb_carac_a_lire);
    close (tub); // fermeture du tampon
    
    if (permet_affichage )
        {if (permet_affichage > 3)
          {for (int i=1;i <= nb_variable; i++)
            cout << "\n variable "<< i<< "= " << t_car_x_n.x[i];
          };
        
         cout << "\n : fermeture du tube en lecture"
              << reception << endl;
        };
  }
 catch(...)
  {cout << "\n *** erreur en lecture des resultats de la fonction externe "
        << nom ;
   cout << flush;
   exit(1);
  };
};

// écriture des données Umat
void F_externe_nD::EcriturePipe()
{try
  {//   Creation d'un processus d'ecriture des variables
   // en fait l'objectif est d'ecrire que les variables qui évoluent
   if (permet_affichage > 2)
        cout << "\n : ouverture du tube en ecriture, ecriture  sur le tube "
             << envoi << endl;

 //      union Tab_car_double_int_1
 //      {  char    tampon[928];
 //         double  x[116];
 //         int     n[232];
 //      } ;

   // le premier élément est le nombre de variables
   // le deuxième élément est le nombre de réel à écrire
   // on considère qu'il a déjà été défini lors du calcul de la fonction

   // ouverture du tube nomme en ecriture
   int tub = open(envoi.c_str(),O_WRONLY);
   int nb_carac_a_ecrire = nb_retour * 8 + 2*4 ;
   write (tub,t_car_x_n.tampon,nb_carac_a_ecrire);
   close (tub); // fermeture du tampon

   if (permet_affichage)
        {cout << "\n ecriture de " << nb_retour << " reels ";
         if (permet_affichage > 3)
          {for (int i=1;i <= nb_retour; i++)
            cout << "\n resultat "<< i<< "= " << t_car_x_n.x[i];
          };
        
         cout << "\n : fermeture du tube en ecriture"
              << envoi << endl;
        };
   }
  catch(...)
   {cout << "\n *** erreur en ecriture des parametre de la fonction externe "
         << nom ;
    cout << flush;
    exit(1);
   };
 };

